; =============================================================================================
; Project Name:		MC_BOSS
; Created:		18th August 2017
; ---------------------------------------------------------------------------------------------
; ASM'd using S1SMPS2ASM version 1.1 by Marc Gordon (AKA Cinossu)
; =============================================================================================

MC_BOSS_Header:
	smpsHeaderVoice	MC_BOSS_Voices
	smpsHeaderChan	$06,	$03
	smpsHeaderTempo	$01,	$14

	smpsHeaderDAC	MC_BOSS_DAC
	smpsHeaderFM	MC_BOSS_FM1,	smpsPitch00,	$0B
	smpsHeaderFM	MC_BOSS_FM2,	smpsPitch00,	$07
	smpsHeaderFM	MC_BOSS_FM3,	smpsPitch00,	$9
	smpsHeaderFM	MC_BOSS_FM4,	smpsPitch00,	$9
	smpsHeaderFM	MC_BOSS_FM5,	smpsPitch00,	$0D
	smpsHeaderPSG	MC_BOSS_PSG1,	smpsPitch00,	$04,	$06
	smpsHeaderPSG	MC_BOSS_PSG2,	smpsPitch00,	$04,	$06
	smpsHeaderPSG	MC_BOSS_PSG3,	smpsPitch00,	$01,	$02

; DAC Data
MC_BOSS_DAC:
	smpsPan		panCentre,	$00
	dc.b		dSnare,	$09,	$05,	$04,	$09,	dKick,	$8F,	$8F
	dc.b		dSnare,	$8F
MC_BOSS_Jump01:
	dc.b		$91,	$24
MC_BOSS_Loop01:
	dc.b		dSnare,	dKick
	smpsLoop	$00,	$0E,	MC_BOSS_Loop01
	dc.b		dSnare,	$1B,	$05,	$04,	$09,	$09,	$8F,	dSnare
	dc.b		dSnare,	dKick,	dSnare,	dSnare,	$91,	$24
MC_BOSS_Loop02:
	dc.b		dSnare,	dKick
	smpsLoop	$00,	$0A,	MC_BOSS_Loop02
	dc.b		dSnare,	$1B,	$8D,	$05,	$04,	$09,	$09,	$09
	dc.b		$09,	$09,	$09,	$8E,	dLowTimpani,	$91,	$24
MC_BOSS_Loop03:
	dc.b		dSnare,	$12,	dKick,	$09,	dSnare,	$12,	$09,	dKick
	dc.b		dKick,	dSnare,	$24,	dKick
	smpsLoop	$00,	$03,	MC_BOSS_Loop03
	dc.b		dSnare,	$12,	dKick,	$09,	dSnare,	$05,	$04,	$09
	dc.b		$09,	dLowTimpani,	dLowTimpani,	dSnare,	dLowTimpani,	dSnare,	dSnare
MC_BOSS_Loop04:
	dc.b		dKick,	$24,	dSnare,	$12,	dKick,	$09,	dSnare,	$12
	dc.b		$09,	dKick,	dKick,	dSnare,	$24
	smpsLoop	$00,	$03,	MC_BOSS_Loop04
	dc.b		dKick,	dSnare,	$12,	dKick,	dSnare,	$09,	$8E,	dLowTimpani
	dc.b		dSnare,	dSnare,	$8F,	dSnare,	dSnare
	smpsJump	MC_BOSS_Jump01

; FM1 Data
MC_BOSS_FM1:
	smpsFMvoice	$00
	smpsPan		panCentre,	$00
	dc.b		nRst,	$48
MC_BOSS_Loop05:
	dc.b		nCs3,	$09,	nEb3,	nEb3,	nCs3,	nEb3,	$12,	nCs3
	dc.b		$09,	nEb3,	$12,	$09,	nCs3,	nEb3,	nE3,	nE3
	dc.b		nCs3,	nEb3
	smpsLoop	$00,	$0E,	MC_BOSS_Loop05
MC_BOSS_Loop06:
	dc.b		nEb3,	$12,	$12,	$12,	$09,	$12,	$12,	$09
	dc.b		$12,	$12,	nA3,	nA3,	nA3,	nA3,	$09,	$12
	dc.b		$12,	$09,	$12,	$12,	nCs3,	nCs3,	nCs3,	nCs3
	dc.b		$09,	$12,	$12,	$09,	$12,	$12,	nAb3,	nAb3
	dc.b		nAb3,	nAb3,	$09,	$12,	$12,	$09,	$12,	$12
	smpsLoop	$00,	$02,	MC_BOSS_Loop06
	smpsJump	MC_BOSS_Loop05

; FM2 Data
MC_BOSS_FM2:
	smpsPan		panCentre,	$00
	dc.b		nRst,	$48
	smpsModSet          $0F, $01, $06, $05
MC_BOSS_Jump02:
	smpsFMvoice	$03
	dc.b		nAb4,	$01
	smpsAlterNote	$01
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$08
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0F
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$13
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$1B
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$E5
	dc.b		smpsNoAttack,	nA4
	smpsAlterNote	$EC
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F3
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FB
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FF
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$07
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0E
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$12
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$1A
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$E1
	dc.b		smpsNoAttack,	nBb4
	smpsAlterNote	$E9
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F1
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F9
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FD
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$22,	nA4,	$7F,	smpsNoAttack,	$35,	nF4,	$1B
	dc.b		nFs4,	nB4,	$02
	smpsAlterNote	$05
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$09
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0B
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0F
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F0
	dc.b		smpsNoAttack,	nC5
	smpsAlterNote	$F4
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F8
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FD
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FF
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$04
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$09
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0B
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0F
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$EE
	dc.b		smpsNoAttack,	nCs5
	smpsAlterNote	$F2
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F7
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FC
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FF
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$22,	nC5,	$7F,	smpsNoAttack,	$6B,	nAb4,	$01
	smpsAlterNote	$01
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$08
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0F
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$13
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$1B
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$E5
	dc.b		smpsNoAttack,	nA4
	smpsAlterNote	$EC
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F3
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FB
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FF
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$07
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0E
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$12
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$1A
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$E1
	dc.b		smpsNoAttack,	nBb4
	smpsAlterNote	$E9
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F1
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F9
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FD
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$22,	nA4,	$5A,	nB4,	$36,	nA4,	$5A
	dc.b		$09,	nBb4,	nRst,	$20
	smpsModSet	$00,	$01,	$07,	$05
	smpsFMvoice	$03
	dc.b		nEb4,	$09,	nFs4,	$04,	nBb4,	$05,	nEb5,	$04
	dc.b		nFs5,	$05,	nAb5,	$04,	nA5,	$05,	nAb5,	$04
	dc.b		nFs5,	$05,	nEb5,	$04,	nCs5,	$05,	nBb4,	$04
	dc.b		nA4,	$05,	nAb4,	$04,	nFs4,	$05,	nA4,	$04
	dc.b		nBb4,	$05,	nAb4,	$04,	nFs4,	$05,	nCs4,	$04
	dc.b		nCs5,	$01
	smpsAlterNote	$01
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$07
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0C
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0F
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$EC
	dc.b		smpsNoAttack,	nD5
	smpsAlterNote	$F2
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F5
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FA
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$01
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$06
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$09
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0F
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$EB
	dc.b		smpsNoAttack,	nEb5
	smpsAlterNote	$F1
	dc.b		smpsNoAttack,	$01,	smpsModOff
	smpsAlterNote	$F7
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FA
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$01
MC_BOSS_Loop07:
	dc.b		smpsModOn,	smpsNoAttack,	$02
	smpsLoop	$00,	$03,	MC_BOSS_Loop07
	dc.b		smpsModOn,	smpsNoAttack,	$03,	smpsModOn,	smpsNoAttack,	$02
	smpsModSet	$00,	$01,	$08,	$05
	dc.b		smpsNoAttack,	$03
MC_BOSS_Loop08:
	dc.b		smpsModOn,	smpsNoAttack,	$02
	smpsLoop	$00,	$03,	MC_BOSS_Loop08
	dc.b		smpsModOn,	smpsNoAttack,	$03
MC_BOSS_Loop09:
	dc.b		smpsModOn,	smpsNoAttack,	$02
	smpsLoop	$00,	$03,	MC_BOSS_Loop09
	dc.b		smpsModOn,	smpsNoAttack,	$03,	smpsModOn,	smpsNoAttack,	$02
	smpsModSet	$00,	$01,	$09,	$05
	dc.b		smpsNoAttack,	$02,	smpsModOn,	smpsNoAttack,	$02,	smpsModOn,	smpsNoAttack,	$03
MC_BOSS_Loop0A:
	dc.b		smpsModOn,	smpsNoAttack,	$02
	smpsLoop	$00,	$03,	MC_BOSS_Loop0A
	dc.b		smpsModOn,	smpsNoAttack,	$03
MC_BOSS_Loop0B:
	dc.b		smpsModOn,	smpsNoAttack,	$02
	smpsLoop	$00,	$03,	MC_BOSS_Loop0B
	smpsModSet	$00,	$01,	$0A,	$05
MC_BOSS_Loop0C:
	dc.b		smpsNoAttack,	$03,	smpsModOn,	smpsNoAttack,	$02,	smpsModOn,	smpsNoAttack,	$02
	dc.b		smpsModOn
	smpsLoop	$00,	$02,	MC_BOSS_Loop0C
	dc.b		smpsNoAttack,	$02,	smpsModOn,	smpsNoAttack,	$03,	smpsModOn,	smpsNoAttack,	$02
	smpsModSet	$00,	$01,	$0B,	$05
	dc.b		smpsNoAttack,	$02,	smpsModOn,	smpsNoAttack,	$02,	smpsModOn,	smpsNoAttack,	$03
MC_BOSS_Loop0D:
	dc.b		smpsModOn,	smpsNoAttack,	$02
	smpsLoop	$00,	$03,	MC_BOSS_Loop0D
	dc.b		smpsModOn,	smpsNoAttack,	$03
MC_BOSS_Loop0E:
	dc.b		smpsModOn,	smpsNoAttack,	$02
	smpsLoop	$00,	$03,	MC_BOSS_Loop0E
	smpsModSet	$00,	$01,	$0C,	$05
MC_BOSS_Loop0F:
	dc.b		smpsNoAttack,	$03,	smpsModOn,	smpsNoAttack,	$02,	smpsModOn
	smpsLoop	$00,	$02,	MC_BOSS_Loop0F
	dc.b		smpsNoAttack,	$02,	smpsModOn,	smpsNoAttack,	$02,	smpsModOn,	smpsNoAttack,	$03
	dc.b		smpsModOn,	smpsNoAttack,	$02,	smpsModOn,	smpsNoAttack,	$02,	smpsModOn,	smpsNoAttack	
	dc.b		$06
	smpsModSet          $0F, $01, $06, $05
	dc.b		nAb4,	$01
	smpsAlterNote	$01
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$08
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0F
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$13
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$1B
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$E5
	dc.b		smpsNoAttack,	nA4
	smpsAlterNote	$EC
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F3
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FB
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FF
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$07
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0E
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$12
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$1A
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$E1
	dc.b		smpsNoAttack,	nBb4
	smpsAlterNote	$E9
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F1
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F9
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FD
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$22,	nA4,	$7F,	smpsNoAttack,	$35,	nF4,	$1B
	dc.b		nFs4,	nB4,	$02
	smpsAlterNote	$05
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$09
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0B
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0F
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F0
	dc.b		smpsNoAttack,	nC5
	smpsAlterNote	$F4
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F8
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FD
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FF
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$04
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$09
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0B
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0F
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$EE
	dc.b		smpsNoAttack,	nCs5
	smpsAlterNote	$F2
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F7
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FC
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FF
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$22,	nC5,	$7F,	smpsNoAttack,	$6B,	nAb4,	$01
	smpsAlterNote	$01
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$08
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0F
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$13
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$1B
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$E5
	dc.b		smpsNoAttack,	nA4
	smpsAlterNote	$EC
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F3
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FB
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FF
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$07
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0E
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$12
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$1A
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$E1
	dc.b		smpsNoAttack,	nBb4
	smpsAlterNote	$E9
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F1
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F9
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FD
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$22,	nA4,	$5A,	nB4,	$02
	smpsAlterNote	$05
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$09
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0B
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0F
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F0
	dc.b		smpsNoAttack,	nC5
	smpsAlterNote	$F4
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F8
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FD
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FF
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$04
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$09
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0B
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0F
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$EE
	dc.b		smpsNoAttack,	nCs5
	smpsAlterNote	$F2
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F7
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FC
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FF
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$22,	nC5,	$36,	nFs4,	$24,	nCs4,	$01
	smpsFMvoice	$04
	smpsAlterNote	$05
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$09
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0D
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0F
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$13
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$EE
	dc.b		smpsNoAttack,	nD4
	smpsAlterNote	$F2
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F7
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FB
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FD
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$01
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$06
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$08
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0C
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$10
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$13
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$EC
	dc.b		smpsNoAttack,	nEb4
	smpsAlterNote	$F1
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F5
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F9
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FE
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$7F,	smpsNoAttack,	$41
	smpsAlterNote	$F5
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0A
	dc.b		smpsNoAttack,	nD4
	smpsAlterNote	$F6
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$EB
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	nCs4,	$7F,	smpsNoAttack,	$7F,	smpsNoAttack,	$20,	nC4
	dc.b		$23
	smpsAlterNote	$06
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$10
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F0
	dc.b		smpsNoAttack,	nCs4
	smpsAlterNote	$FB
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$21
	smpsAlterNote	$03
	dc.b		$01
	smpsAlterNote	$05
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$09
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0D
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0F
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$13
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$EE
	dc.b		smpsNoAttack,	nD4
	smpsAlterNote	$F2
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F7
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FB
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FD
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$01
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$06
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$08
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0C
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$10
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$13
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$EC
	dc.b		smpsNoAttack,	nEb4
	smpsAlterNote	$F1
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F5
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F9
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FE
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$7F,	smpsNoAttack,	$41
	smpsAlterNote	$F5
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0A
	dc.b		smpsNoAttack,	nD4
	smpsAlterNote	$F6
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$EB
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	nCs4,	$7F,	smpsNoAttack,	$7F,	smpsNoAttack,	$20,	nC4
	dc.b		$24,	nFs4,	$12
	smpsAlterNote	$FC
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F9
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F1
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$EA
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$19
	dc.b		smpsNoAttack,	nF4
	smpsAlterNote	$12
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0A
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$07
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FF
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F8
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F1
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$EA
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$13
	dc.b		smpsNoAttack,	nE4
	smpsAlterNote	$0F
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$08
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$02
	dc.b		smpsNoAttack,	$02
	smpsAlterNote	$01
	dc.b		smpsNoAttack,	$01
	smpsJump	MC_BOSS_Jump02

; FM3 Data
MC_BOSS_FM3:
	smpsFMvoice	$01
	smpsPan		panCentre,	$00
	dc.b		nRst,	$01,	nEb3
	smpsAlterNote	$01
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$02
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$03
	dc.b		smpsNoAttack,	$02
	smpsAlterNote	$04
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$06
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$07
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$08
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$09
	dc.b		smpsNoAttack,	$02
	smpsAlterNote	$0B
	dc.b		smpsNoAttack,	$02
	smpsAlterNote	$0C
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0E
	dc.b		smpsNoAttack,	$02
	smpsAlterNote	$0F
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$10
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$11
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$12
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$13
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$14
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$15
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$16
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$E9
	dc.b		smpsNoAttack,	nE3
	smpsAlterNote	$EA
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$EC
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$ED
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$EE
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$EF
	dc.b		smpsNoAttack,	$02
	smpsAlterNote	$F1
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F2
	dc.b		smpsNoAttack,	$02
	smpsAlterNote	$F3
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F4
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F5
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F7
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F8
	dc.b		smpsNoAttack,	$02
	smpsAlterNote	$FA
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FB
	dc.b		smpsNoAttack,	$02
	smpsAlterNote	$FC
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FD
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FE
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FF
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$02
	dc.b		smpsNoAttack,	$02
	smpsAlterNote	$03
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$05
	dc.b		smpsNoAttack,	$02
	smpsAlterNote	$06
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$07
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$08
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$09
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0A
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0C
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0D
	dc.b		smpsNoAttack,	$02
	smpsAlterNote	$0E
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$10
	dc.b		smpsNoAttack,	$02
	smpsAlterNote	$11
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$13
	dc.b		smpsNoAttack,	$02
	smpsAlterNote	$14
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$15
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$16
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$17
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
MC_BOSS_Loop11:
	dc.b		nEb2,	$12,	$05
MC_BOSS_Loop10:
	dc.b		nRst,	$04,	nEb2,	$05
	smpsLoop	$00,	$03,	MC_BOSS_Loop10
	dc.b		nRst,	$04
	smpsLoop	$01,	$02,	MC_BOSS_Loop11
MC_BOSS_Loop12:
	dc.b		nEb2
MC_BOSS_Loop13:
	dc.b		$05,	nRst,	$04
	smpsLoop	$00,	$04,	MC_BOSS_Loop12
	dc.b		nEb2,	$12
	smpsLoop	$01,	$02,	MC_BOSS_Loop13
	dc.b		$05,	nRst,	$04,	nEb2,	$05
MC_BOSS_Loop14:
	dc.b		nRst,	$04,	nF2,	$05
	smpsLoop	$00,	$03,	MC_BOSS_Loop14
MC_BOSS_Loop15:
	dc.b		nRst,	$04,	nFs2,	$05
	smpsLoop	$00,	$03,	MC_BOSS_Loop15
MC_BOSS_Loop17:
	dc.b		nRst,	$04,	nEb2,	$12,	$05
MC_BOSS_Loop16:
	dc.b		nRst,	$04,	nEb2,	$05
	smpsLoop	$00,	$03,	MC_BOSS_Loop16
	smpsLoop	$01,	$02,	MC_BOSS_Loop17
MC_BOSS_Loop18:
	dc.b		nRst,	$04,	nEb2,	$05
	smpsLoop	$00,	$04,	MC_BOSS_Loop18
	smpsLoop	$02,	$07,	MC_BOSS_Loop17
	dc.b		nRst,	$04,	nEb2,	$12,	$05
MC_BOSS_Loop19:
	dc.b		nRst,	$04,	nEb2,	$05
	smpsLoop	$00,	$03,	MC_BOSS_Loop19
	dc.b		nRst,	$04,	nEb2,	$12,	$05,	nRst,	$04,	nEb2
	dc.b		$05
MC_BOSS_Loop1A:
	dc.b		nRst,	$04,	nF2,	$05
	smpsLoop	$00,	$03,	MC_BOSS_Loop1A
MC_BOSS_Loop1B:
	dc.b		nRst,	$04,	nFs2,	$05
	smpsLoop	$00,	$03,	MC_BOSS_Loop1B
MC_BOSS_Loop1D:
	dc.b		nRst,	$04,	nEb2,	$12,	$05
MC_BOSS_Loop1C:
	dc.b		nRst,	$04,	nEb2,	$05
	smpsLoop	$00,	$03,	MC_BOSS_Loop1C
	smpsLoop	$01,	$02,	MC_BOSS_Loop1D
MC_BOSS_Loop1E:
	dc.b		nRst,	$04,	nEb2,	$05
	smpsLoop	$00,	$04,	MC_BOSS_Loop1E
	smpsLoop	$02,	$05,	MC_BOSS_Loop1D
MC_BOSS_Loop20:
	dc.b		nRst,	$04,	nA2,	$12,	$05
MC_BOSS_Loop1F:
	dc.b		nRst,	$04,	nA2,	$05
	smpsLoop	$00,	$03,	MC_BOSS_Loop1F
	smpsLoop	$01,	$02,	MC_BOSS_Loop20
MC_BOSS_Loop21:
	dc.b		nRst,	$04,	nA2,	$05
	smpsLoop	$00,	$04,	MC_BOSS_Loop21
MC_BOSS_Loop23:
	dc.b		nRst,	$04,	nCs2,	$12,	$05
MC_BOSS_Loop22:
	dc.b		nRst,	$04,	nCs2,	$05
	smpsLoop	$00,	$03,	MC_BOSS_Loop22
	smpsLoop	$01,	$02,	MC_BOSS_Loop23
MC_BOSS_Loop24:
	dc.b		nRst,	$04,	nCs2,	$05
	smpsLoop	$00,	$04,	MC_BOSS_Loop24
MC_BOSS_Loop26:
	dc.b		nRst,	$04,	nAb2,	$12,	$05
MC_BOSS_Loop25:
	dc.b		nRst,	$04,	nAb2,	$05
	smpsLoop	$00,	$03,	MC_BOSS_Loop25
	smpsLoop	$01,	$02,	MC_BOSS_Loop26
MC_BOSS_Loop27:
	dc.b		nRst,	$04,	nAb2,	$05
	smpsLoop	$00,	$04,	MC_BOSS_Loop27
MC_BOSS_Loop29:
	dc.b		nRst,	$04,	nEb2,	$12,	$05
MC_BOSS_Loop28:
	dc.b		nRst,	$04,	nEb2,	$05
	smpsLoop	$00,	$03,	MC_BOSS_Loop28
	smpsLoop	$01,	$02,	MC_BOSS_Loop29
MC_BOSS_Loop2A:
	dc.b		nRst,	$04,	nEb2,	$05
	smpsLoop	$00,	$04,	MC_BOSS_Loop2A
MC_BOSS_Loop2C:
	dc.b		nRst,	$04,	nA2,	$12,	$05
MC_BOSS_Loop2B:
	dc.b		nRst,	$04,	nA2,	$05
	smpsLoop	$00,	$03,	MC_BOSS_Loop2B
	smpsLoop	$01,	$02,	MC_BOSS_Loop2C
MC_BOSS_Loop2D:
	dc.b		nRst,	$04,	nA2,	$05
	smpsLoop	$00,	$04,	MC_BOSS_Loop2D
MC_BOSS_Loop2F:
	dc.b		nRst,	$04,	nCs2,	$12,	$05
MC_BOSS_Loop2E:
	dc.b		nRst,	$04,	nCs2,	$05
	smpsLoop	$00,	$03,	MC_BOSS_Loop2E
	smpsLoop	$01,	$02,	MC_BOSS_Loop2F
MC_BOSS_Loop30:
	dc.b		nRst,	$04,	nCs2,	$05
	smpsLoop	$00,	$04,	MC_BOSS_Loop30
MC_BOSS_Loop32:
	dc.b		nRst,	$04,	nAb2,	$12,	$05
MC_BOSS_Loop31:
	dc.b		nRst,	$04,	nAb2,	$05
	smpsLoop	$00,	$03,	MC_BOSS_Loop31
	smpsLoop	$01,	$02,	MC_BOSS_Loop32
MC_BOSS_Loop33:
	dc.b		nRst,	$04,	nAb2,	$05
	smpsLoop	$00,	$04,	MC_BOSS_Loop33
	dc.b		nRst,	$04
	smpsJump	MC_BOSS_Loop11

; FM4 Data
MC_BOSS_FM4:
	smpsFMvoice	$02
	smpsPan		panCentre,	$00
	dc.b		nRst,	$01,	nEb3
	smpsAlterNote	$01
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$02
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$03
	dc.b		smpsNoAttack,	$02
	smpsAlterNote	$04
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$06
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$07
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$08
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$09
	dc.b		smpsNoAttack,	$02
	smpsAlterNote	$0B
	dc.b		smpsNoAttack,	$02
	smpsAlterNote	$0C
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0E
	dc.b		smpsNoAttack,	$02
	smpsAlterNote	$0F
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$10
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$11
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$12
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$13
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$14
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$15
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$16
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$E9
	dc.b		smpsNoAttack,	nE3
	smpsAlterNote	$EA
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$EC
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$ED
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$EE
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$EF
	dc.b		smpsNoAttack,	$02
	smpsAlterNote	$F1
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F2
	dc.b		smpsNoAttack,	$02
	smpsAlterNote	$F3
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F4
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F5
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F7
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F8
	dc.b		smpsNoAttack,	$02
	smpsAlterNote	$FA
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FB
	dc.b		smpsNoAttack,	$02
	smpsAlterNote	$FC
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FD
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FE
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FF
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$02
	dc.b		smpsNoAttack,	$02
	smpsAlterNote	$03
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$05
	dc.b		smpsNoAttack,	$02
	smpsAlterNote	$06
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$07
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$08
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$09
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0A
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0C
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0D
	dc.b		smpsNoAttack,	$02
	smpsAlterNote	$0E
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$10
	dc.b		smpsNoAttack,	$02
	smpsAlterNote	$11
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$13
	dc.b		smpsNoAttack,	$02
	smpsAlterNote	$14
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$15
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$16
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$17
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
MC_BOSS_Loop35:
	dc.b		nEb2,	$11,	nRst,	$01
MC_BOSS_Loop34:
	dc.b		nEb2,	$03,	nRst,	$06
	smpsLoop	$00,	$04,	MC_BOSS_Loop34
	smpsLoop	$01,	$02,	MC_BOSS_Loop35
	smpsLoop	$02,	$02,	MC_BOSS_Loop34
	dc.b		nEb2,	$11,	nRst,	$01,	nEb2,	$03,	nRst,	$06
	dc.b		nEb2,	$03
MC_BOSS_Loop36:
	dc.b		nRst,	$06,	nF2,	$03
	smpsLoop	$00,	$03,	MC_BOSS_Loop36
MC_BOSS_Loop37:
	dc.b		nRst,	$06,	nFs2,	$03
	smpsLoop	$00,	$03,	MC_BOSS_Loop37
	dc.b		nRst,	$06
MC_BOSS_Loop39:
	dc.b		nEb2,	$11,	nRst,	$01
MC_BOSS_Loop38:
	dc.b		nEb2,	$03,	nRst,	$06
	smpsLoop	$00,	$04,	MC_BOSS_Loop38
	smpsLoop	$01,	$02,	MC_BOSS_Loop39
	smpsLoop	$02,	$02,	MC_BOSS_Loop38
	dc.b		nEb2,	$11,	nRst,	$01
MC_BOSS_Loop3A:
	dc.b		nEb2,	$03,	nRst,	$06
	smpsLoop	$00,	$08,	MC_BOSS_Loop3A
	smpsLoop	$03,	$03,	MC_BOSS_Loop39
MC_BOSS_Loop3C:
	dc.b		nEb2,	$11,	nRst,	$01
MC_BOSS_Loop3B:
	dc.b		nEb2,	$03,	nRst,	$06
	smpsLoop	$00,	$04,	MC_BOSS_Loop3B
	smpsLoop	$01,	$02,	MC_BOSS_Loop3C
	smpsLoop	$02,	$02,	MC_BOSS_Loop3B
	dc.b		nEb2,	$11,	nRst,	$01,	nEb2,	$03,	nRst,	$06
	dc.b		nEb2,	$03
MC_BOSS_Loop3D:
	dc.b		nRst,	$06,	nF2,	$03
	smpsLoop	$00,	$03,	MC_BOSS_Loop3D
MC_BOSS_Loop3E:
	dc.b		nRst,	$06,	nFs2,	$03
	smpsLoop	$00,	$03,	MC_BOSS_Loop3E
	dc.b		nRst,	$06
MC_BOSS_Loop40:
	dc.b		nEb2,	$11,	nRst,	$01
MC_BOSS_Loop3F:
	dc.b		nEb2,	$03,	nRst,	$06
	smpsLoop	$00,	$04,	MC_BOSS_Loop3F
	smpsLoop	$01,	$02,	MC_BOSS_Loop40
	smpsLoop	$02,	$02,	MC_BOSS_Loop3F
	dc.b		nEb2,	$11,	nRst,	$01
MC_BOSS_Loop41:
	dc.b		nEb2,	$03,	nRst,	$06
	smpsLoop	$00,	$08,	MC_BOSS_Loop41
	smpsLoop	$03,	$02,	MC_BOSS_Loop40
MC_BOSS_Loop43:
	dc.b		nEb2,	$11,	nRst,	$01
MC_BOSS_Loop42:
	dc.b		nEb2,	$03,	nRst,	$06
	smpsLoop	$00,	$04,	MC_BOSS_Loop42
	smpsLoop	$01,	$02,	MC_BOSS_Loop43
MC_BOSS_Loop44:
	dc.b		nEb2,	$03,	nRst,	$06
	smpsLoop	$00,	$04,	MC_BOSS_Loop44
MC_BOSS_Loop46:
	dc.b		nA2,	$11,	nRst,	$01
MC_BOSS_Loop45:
	dc.b		nA2,	$03,	nRst,	$06
	smpsLoop	$00,	$04,	MC_BOSS_Loop45
	smpsLoop	$01,	$02,	MC_BOSS_Loop46
MC_BOSS_Loop47:
	dc.b		nA2,	$03,	nRst,	$06
	smpsLoop	$00,	$04,	MC_BOSS_Loop47
MC_BOSS_Loop49:
	dc.b		nCs2,	$11,	nRst,	$01
MC_BOSS_Loop48:
	dc.b		nCs2,	$03,	nRst,	$06
	smpsLoop	$00,	$04,	MC_BOSS_Loop48
	smpsLoop	$01,	$02,	MC_BOSS_Loop49
MC_BOSS_Loop4A:
	dc.b		nCs2,	$03,	nRst,	$06
	smpsLoop	$00,	$04,	MC_BOSS_Loop4A
MC_BOSS_Loop4C:
	dc.b		nAb2,	$11,	nRst,	$01
MC_BOSS_Loop4B:
	dc.b		nAb2,	$03,	nRst,	$06
	smpsLoop	$00,	$04,	MC_BOSS_Loop4B
	smpsLoop	$01,	$02,	MC_BOSS_Loop4C
MC_BOSS_Loop4D:
	dc.b		nAb2,	$03,	nRst,	$06
	smpsLoop	$00,	$04,	MC_BOSS_Loop4D
	smpsLoop	$02,	$02,	MC_BOSS_Loop43
	smpsJump	MC_BOSS_Loop35

; FM5 Data
MC_BOSS_FM5:	
	smpsPan		panRight,	$00
	dc.b		nRst,	$5F
	smpsAlterNoteEcho	$00
	smpsModSet          $0F, $01, $06, $05
MC_BOSS_Jump03:
	smpsFMvoice	$03
	dc.b		nAb4,	$01
	smpsAlterNoteEcho	$05
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$0C
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$13
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$1B
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$E1
	dc.b		smpsNoAttack,	nA4
	smpsAlterNoteEcho	$E8
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$F0
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$F3
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$FB
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$03
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$0A
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$12
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$1A
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$1D
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$E5
	dc.b		smpsNoAttack,	nBb4
	smpsAlterNoteEcho	$ED
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$F1
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$F9
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$00
	dc.b		smpsNoAttack,	$23,	nA4,	$7F,	smpsNoAttack,	$35,	nF4,	$1B
	dc.b		nFs4,	nB4,	$01
	smpsAlterNoteEcho	$02
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$07
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$0B
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$0F
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$ED
	dc.b		smpsNoAttack,	nC5
	smpsAlterNoteEcho	$F2
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$F6
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$F8
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$FD
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$02
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$06
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$0B
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$0F
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$11
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$F0
	dc.b		smpsNoAttack,	nCs5
	smpsAlterNoteEcho	$F5
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$F7
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$FC
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$00
	dc.b		smpsNoAttack,	$23,	nC5,	$7F,	smpsNoAttack,	$6B,	nAb4,	$01
	smpsAlterNoteEcho	$05
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$0C
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$13
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$1B
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$E1
	dc.b		smpsNoAttack,	nA4
	smpsAlterNoteEcho	$E8
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$F0
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$F3
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$FB
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$03
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$0A
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$12
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$1A
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$1D
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$E5
	dc.b		smpsNoAttack,	nBb4
	smpsAlterNoteEcho	$ED
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$F1
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$F9
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$00
	dc.b		smpsNoAttack,	$23,	nA4,	$5A,	nB4,	$36,	nA4,	$5A
	dc.b		$09,	nBb4,	nRst,	$1F
	smpsModSet	$00,	$01,	$07,	$05
	smpsFMvoice	$03
	dc.b		nEb4,	$09,	nFs4,	$05,	nBb4,	$04,	nEb5,	$05
	dc.b		nFs5,	$04,	nAb5,	$05,	nA5,	$04,	nAb5,	$05
	dc.b		nFs5,	$04,	nEb5,	$05,	nCs5,	$04,	nBb4,	$05
	dc.b		nA4,	$04,	nAb4,	$05,	nFs4,	$04,	nA4,	$05
	dc.b		nBb4,	$04,	nAb4,	$05,	nFs4,	$04,	nCs4,	$05
	dc.b		nCs5,	$01
	smpsAlterNoteEcho	$04
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$09
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$0F
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$12
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$EF
	dc.b		smpsNoAttack,	nD5
	smpsAlterNoteEcho	$F5
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$FA
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$FE
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$04
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$09
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$0C
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$13
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$EE
	dc.b		smpsNoAttack,	nEb5
	smpsAlterNoteEcho	$F1
	dc.b		smpsNoAttack,	$01,	smpsModOff
	smpsAlterNoteEcho	$F7
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$FE
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$00
	dc.b		smpsModOn,	smpsNoAttack,	$02,	smpsModOn,	smpsNoAttack,	$03
MC_BOSS_Loop4E:
	dc.b		smpsModOn,	smpsNoAttack,	$02
	smpsLoop	$00,	$03,	MC_BOSS_Loop4E
	smpsModSet	$00,	$01,	$08,	$05
MC_BOSS_Loop4F:
	dc.b		smpsNoAttack,	$03,	smpsModOn,	smpsNoAttack,	$02,	smpsModOn
	smpsLoop	$00,	$02,	MC_BOSS_Loop4F
	dc.b		smpsNoAttack,	$02,	smpsModOn,	smpsNoAttack,	$02,	smpsModOn,	smpsNoAttack,	$03
MC_BOSS_Loop50:
	dc.b		smpsModOn,	smpsNoAttack,	$02
	smpsLoop	$00,	$03,	MC_BOSS_Loop50
	smpsModSet	$00,	$01,	$09,	$05
	dc.b		smpsNoAttack,	$03
MC_BOSS_Loop51:
	dc.b		smpsModOn,	smpsNoAttack,	$02
	smpsLoop	$00,	$03,	MC_BOSS_Loop51
	dc.b		smpsModOn,	smpsNoAttack,	$03
MC_BOSS_Loop52:
	dc.b		smpsModOn,	smpsNoAttack,	$02
	smpsLoop	$00,	$03,	MC_BOSS_Loop52
	dc.b		smpsModOn,	smpsNoAttack,	$03,	smpsModOn,	smpsNoAttack,	$02
	smpsModSet	$00,	$01,	$0A,	$05
	dc.b		smpsNoAttack,	$02,	smpsModOn,	smpsNoAttack,	$03
MC_BOSS_Loop53:
	dc.b		smpsModOn,	smpsNoAttack,	$02
	smpsLoop	$00,	$03,	MC_BOSS_Loop53
	dc.b		smpsModOn,	smpsNoAttack,	$03
MC_BOSS_Loop54:
	dc.b		smpsModOn,	smpsNoAttack,	$02
	smpsLoop	$00,	$03,	MC_BOSS_Loop54
	smpsModSet	$00,	$01,	$0B,	$05
	dc.b		smpsNoAttack,	$03
MC_BOSS_Loop55:
	dc.b		smpsModOn,	smpsNoAttack,	$02
	smpsLoop	$00,	$03,	MC_BOSS_Loop55
	dc.b		smpsModOn,	smpsNoAttack,	$03
MC_BOSS_Loop56:
	dc.b		smpsModOn,	smpsNoAttack,	$02
	smpsLoop	$00,	$03,	MC_BOSS_Loop56
	dc.b		smpsModOn,	smpsNoAttack,	$03,	smpsModOn,	smpsNoAttack,	$02
	smpsModSet	$00,	$01,	$0C,	$05
MC_BOSS_Loop57:
	dc.b		smpsNoAttack,	$02,	smpsModOn,	smpsNoAttack,	$03,	smpsModOn,	smpsNoAttack,	$02
	dc.b		smpsModOn
	smpsLoop	$00,	$02,	MC_BOSS_Loop57
	dc.b		smpsNoAttack,	$02,	smpsModOn,	smpsNoAttack,	$02,	smpsModOn,	smpsNoAttack,	$03
	dc.b		smpsModOn,	smpsNoAttack,	$06	
	smpsModSet          $0F, $01, $06, $05
	dc.b		nAb4,	$01
	smpsAlterNoteEcho	$05
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$0C
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$13
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$1B
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$E1
	dc.b		smpsNoAttack,	nA4
	smpsAlterNoteEcho	$E8
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$F0
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$F3
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$FB
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$03
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$0A
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$12
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$1A
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$1D
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$E5
	dc.b		smpsNoAttack,	nBb4
	smpsAlterNoteEcho	$ED
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$F1
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$F9
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$00
	dc.b		smpsNoAttack,	$23,	nA4,	$7F,	smpsNoAttack,	$35,	nF4,	$1B
	dc.b		nFs4,	nB4,	$01
	smpsAlterNoteEcho	$02
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$07
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$0B
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$0F
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$ED
	dc.b		smpsNoAttack,	nC5
	smpsAlterNoteEcho	$F2
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$F6
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$F8
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$FD
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$02
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$06
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$0B
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$0F
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$11
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$F0
	dc.b		smpsNoAttack,	nCs5
	smpsAlterNoteEcho	$F5
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$F7
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$FC
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$00
	dc.b		smpsNoAttack,	$23,	nC5,	$7F,	smpsNoAttack,	$6B,	nAb4,	$01
	smpsAlterNoteEcho	$05
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$0C
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$13
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$1B
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$E1
	dc.b		smpsNoAttack,	nA4
	smpsAlterNoteEcho	$E8
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$F0
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$F3
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$FB
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$03
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$0A
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$12
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$1A
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$1D
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$E5
	dc.b		smpsNoAttack,	nBb4
	smpsAlterNoteEcho	$ED
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$F1
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$F9
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$00
	dc.b		smpsNoAttack,	$23,	nA4,	$5A,	nB4,	$01
	smpsAlterNoteEcho	$02
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$07
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$0B
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$0F
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$ED
	dc.b		smpsNoAttack,	nC5
	smpsAlterNoteEcho	$F2
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$F6
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$F8
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$FD
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$02
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$06
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$0B
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$0F
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$11
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$F0
	dc.b		smpsNoAttack,	nCs5
	smpsAlterNoteEcho	$F5
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$F7
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$FC
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$00
	dc.b		smpsNoAttack,	$23,	nC5,	$36,	nFs4,	$24,	nCs4,	$01
	smpsFMvoice	$04
	smpsAlterNoteEcho	$07
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$0B
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$0F
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$13
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$EC
	dc.b		smpsNoAttack,	nD4
	smpsAlterNoteEcho	$F0
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$F5
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$F7
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$FB
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$FF
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$04
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$06
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$0A
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$0E
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$13
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$EC
	dc.b		smpsNoAttack,	nEb4
	smpsAlterNoteEcho	$EE
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$F3
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$F7
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$F9
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$FE
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$00
	dc.b		smpsNoAttack,	$7F,	smpsNoAttack,	$41
	smpsAlterNoteEcho	$EA
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$0A
	dc.b		smpsNoAttack,	nD4
	smpsAlterNoteEcho	$F6
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$0B
	dc.b		smpsNoAttack,	nCs4
	smpsAlterNoteEcho	$00
	dc.b		smpsNoAttack,	$7F,	smpsNoAttack,	$7F,	smpsNoAttack,	$20,	nC4,	$22
	smpsAlterNoteEcho	$01
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$06
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$10
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$F5
	dc.b		smpsNoAttack,	nCs4
	smpsAlterNoteEcho	$FB
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$00
	dc.b		smpsNoAttack,	$21
	smpsAlterNoteEcho	$03
	dc.b		$01
	smpsAlterNoteEcho	$07
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$0B
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$0F
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$13
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$EC
	dc.b		smpsNoAttack,	nD4
	smpsAlterNoteEcho	$F0
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$F5
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$F7
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$FB
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$FF
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$04
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$06
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$0A
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$0E
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$13
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$EC
	dc.b		smpsNoAttack,	nEb4
	smpsAlterNoteEcho	$EE
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$F3
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$F7
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$F9
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$FE
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$00
	dc.b		smpsNoAttack,	$7F,	smpsNoAttack,	$41
	smpsAlterNoteEcho	$EA
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$0A
	dc.b		smpsNoAttack,	nD4
	smpsAlterNoteEcho	$F6
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$0B
	dc.b		smpsNoAttack,	nCs4
	smpsAlterNoteEcho	$00
	dc.b		smpsNoAttack,	$7F,	smpsNoAttack,	$7F,	smpsNoAttack,	$20,	nC4,	$24
	dc.b		nFs4,	$12
	smpsAlterNoteEcho	$FC
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$F5
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$ED
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$19
	dc.b		smpsNoAttack,	nF4
	smpsAlterNoteEcho	$12
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$0E
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$07
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$FF
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$FB
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$F4
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$ED
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$EA
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$13
	dc.b		smpsNoAttack,	nE4
	smpsAlterNoteEcho	$0C
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$08
	dc.b		smpsNoAttack,	$01
	smpsAlterNoteEcho	$02
	dc.b		smpsNoAttack,	$02
	smpsAlterNoteEcho	$01
	dc.b		smpsNoAttack,	$01
	smpsJump	MC_BOSS_Jump03

; PSG1 Data
MC_BOSS_PSG1:
	dc.b		nRst,	$01,	$47
MC_BOSS_Jump04:
	dc.b		nAb1,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FE
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FC
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FB
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FA
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$07
	dc.b		smpsNoAttack,	nA1
	smpsAlterNote	$05
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$03
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$01
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FF
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FD
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FC
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FA
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$07
	dc.b		smpsNoAttack,	nBb1
	smpsAlterNote	$05
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$03
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$01
	dc.b		smpsNoAttack,	$02
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$22,	nA1,	$7F,	smpsNoAttack,	$35,	nF1,	$1B
	dc.b		nFs1,	nB1,	$02
	smpsAlterNote	$FF
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FD
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FC
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FB
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$05
	dc.b		smpsNoAttack,	nC2
	smpsAlterNote	$04
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$02
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$01
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FE
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FD
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FC
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FB
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$05
	dc.b		smpsNoAttack,	nCs2
	smpsAlterNote	$04
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$02
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$01
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$01,	smpsNoAttack,	$22,	nC2,	$7F,	smpsNoAttack,	$6B
	dc.b		nAb1,	$02
	smpsAlterNote	$FE
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FC
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FB
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FA
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$07
	dc.b		smpsNoAttack,	nA1
	smpsAlterNote	$05
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$03
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$01
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FF
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FD
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FC
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FA
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$07
	dc.b		smpsNoAttack,	nBb1
	smpsAlterNote	$05
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$03
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$01
	dc.b		smpsNoAttack,	$02
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$22,	nA1,	$5A,	nB1,	$36,	nA1,	$5A
	dc.b		$09,	nBb1,	nRst,	$7F,	$7F,	$10,	nAb1,	$02
	smpsAlterNote	$FE
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FC
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FB
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FA
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$07
	dc.b		smpsNoAttack,	nA1
	smpsAlterNote	$05
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$03
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$01
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FF
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FD
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FC
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FA
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$07
	dc.b		smpsNoAttack,	nBb1
	smpsAlterNote	$05
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$03
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$01
	dc.b		smpsNoAttack,	$02
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$22,	nA1,	$7F,	smpsNoAttack,	$35,	nF1,	$1B
	dc.b		nFs1,	nB1,	$02
	smpsAlterNote	$FF
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FD
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FC
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FB
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$05
	dc.b		smpsNoAttack,	nC2
	smpsAlterNote	$04
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$02
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$01
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FE
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FD
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FC
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FB
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$05
	dc.b		smpsNoAttack,	nCs2
	smpsAlterNote	$04
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$02
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$01
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$01,	smpsNoAttack,	$22,	nC2,	$7F,	smpsNoAttack,	$6B
	dc.b		nAb1,	$02
	smpsAlterNote	$FE
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FC
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FB
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FA
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$07
	dc.b		smpsNoAttack,	nA1
	smpsAlterNote	$05
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$03
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$01
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FF
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FD
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FC
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FA
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$07
	dc.b		smpsNoAttack,	nBb1
	smpsAlterNote	$05
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$03
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$01
	dc.b		smpsNoAttack,	$02
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$22,	nA1,	$5A,	nB1,	$02
	smpsAlterNote	$FF
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FD
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FC
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FB
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$05
	dc.b		smpsNoAttack,	nC2
	smpsAlterNote	$04
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$02
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$01
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FE
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FD
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FC
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FB
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$05
	dc.b		smpsNoAttack,	nCs2
	smpsAlterNote	$04
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$02
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$01
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$01,	smpsNoAttack,	$22,	nC2,	$36,	nFs1,	$24
	smpsAlterNote	$FF
	dc.b		nCs2,	$01
	smpsAlterNote	$FE
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FD
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FC
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FB
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FA
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$05
	dc.b		smpsNoAttack,	nD2
	smpsAlterNote	$04
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$03
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$02
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$01
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FF
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FE
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FD
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FC
	dc.b		smpsNoAttack,	$02
	smpsAlterNote	$05
	dc.b		smpsNoAttack,	nEb2,	$01
	smpsAlterNote	$03
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$02
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$01
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$01,	smpsNoAttack,	$7F,	smpsNoAttack,	$41
	smpsAlterNote	$02
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FE
	dc.b		smpsNoAttack,	nD2
	smpsAlterNote	$03
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$06
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	nCs2,	$7F,	smpsNoAttack,	$7F,	smpsNoAttack,	$20,	nC2
	dc.b		$23
	smpsAlterNote	$FE
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FA
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$05
	dc.b		smpsNoAttack,	nCs2
	smpsAlterNote	$01
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$21
	smpsAlterNote	$FF
	dc.b		$01
	smpsAlterNote	$FE
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FD
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FC
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FB
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FA
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$05
	dc.b		smpsNoAttack,	nD2
	smpsAlterNote	$04
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$03
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$02
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$01
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FF
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FE
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FD
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FC
	dc.b		smpsNoAttack,	$02
	smpsAlterNote	$05
	dc.b		smpsNoAttack,	nEb2,	$01
	smpsAlterNote	$03
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$02
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$01
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$01,	smpsNoAttack,	$7F,	smpsNoAttack,	$41
	smpsAlterNote	$02
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FE
	dc.b		smpsNoAttack,	nD2
	smpsAlterNote	$03
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$06
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	nCs2,	$7F,	smpsNoAttack,	$7F,	smpsNoAttack,	$20,	nC2
	dc.b		$24,	nFs2,	$12
	smpsAlterNote	$01
	dc.b		smpsNoAttack,	$02
	smpsAlterNote	$03
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$04
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FC
	dc.b		smpsNoAttack,	nF2
	smpsAlterNote	$FD
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FE
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FF
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$02
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$03
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$04
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FC
	dc.b		smpsNoAttack,	nE2
	smpsAlterNote	$FD
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FE
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FF
	dc.b		smpsNoAttack,	$03
	smpsJump	MC_BOSS_Jump04

; PSG2 Data
MC_BOSS_PSG2:
	dc.b		nRst,	$01,	$47
MC_BOSS_Jump05:
	dc.b		nCs1,	$01
	smpsAlterNote	$FF
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FC
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FA
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F8
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F5
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0A
	dc.b		smpsNoAttack,	nD1
	smpsAlterNote	$07
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$04
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$01
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FE
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FB
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FA
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F7
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$09
	dc.b		smpsNoAttack,	nEb1
	smpsAlterNote	$07
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$04
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$02
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$01,	smpsNoAttack,	$22,	$7F,	smpsNoAttack,	$35,	nC1
	dc.b		$1B,	nCs1,	nE1,	$02
	smpsAlterNote	$FE
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FB
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FA
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F8
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$09
	dc.b		smpsNoAttack,	nF1
	smpsAlterNote	$06
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$04
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$02
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FE
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FC
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FB
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F9
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$09
	dc.b		smpsNoAttack,	nFs1
	smpsAlterNote	$07
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$04
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$02
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$01
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$7F,	smpsNoAttack,	$7F,	smpsNoAttack,	$0E,	nCs1,	$01
	smpsAlterNote	$FF
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FC
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FA
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F8
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F5
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0A
	dc.b		smpsNoAttack,	nD1
	smpsAlterNote	$07
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$04
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$01
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FE
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FB
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FA
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F7
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$09
	dc.b		smpsNoAttack,	nEb1
	smpsAlterNote	$07
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$04
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$02
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$01,	smpsNoAttack,	$22,	$5A,	$36,	$5A,	$12
	dc.b		nRst,	$7F,	$7F,	$10,	nCs1,	$01
	smpsAlterNote	$FF
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FC
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FA
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F8
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F5
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0A
	dc.b		smpsNoAttack,	nD1
	smpsAlterNote	$07
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$04
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$01
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FE
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FB
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FA
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F7
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$09
	dc.b		smpsNoAttack,	nEb1
	smpsAlterNote	$07
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$04
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$02
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$01,	smpsNoAttack,	$22,	$7F,	smpsNoAttack,	$35,	nC1
	dc.b		$1B,	nCs1,	nE1,	$02
	smpsAlterNote	$FE
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FB
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FA
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F8
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$09
	dc.b		smpsNoAttack,	nF1
	smpsAlterNote	$06
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$04
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$02
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FE
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FC
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FB
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F9
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$09
	dc.b		smpsNoAttack,	nFs1
	smpsAlterNote	$07
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$04
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$02
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$01
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$7F,	smpsNoAttack,	$7F,	smpsNoAttack,	$0E,	nCs1,	$01
	smpsAlterNote	$FF
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FC
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FA
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F8
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F5
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0A
	dc.b		smpsNoAttack,	nD1
	smpsAlterNote	$07
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$04
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$01
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FE
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FB
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FA
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F7
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$09
	dc.b		smpsNoAttack,	nEb1
	smpsAlterNote	$07
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$04
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$02
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$01,	smpsNoAttack,	$22,	$5A,	nE1,	$02
	smpsAlterNote	$FE
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FB
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FA
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F8
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$09
	dc.b		smpsNoAttack,	nF1
	smpsAlterNote	$06
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$04
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$02
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FE
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FC
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FB
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F9
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$09
	dc.b		smpsNoAttack,	nFs1
	smpsAlterNote	$07
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$04
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$02
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$01
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$22,	$36,	nEb1,	$24
	smpsAlterNote	$FE
	dc.b		nCs1,	$01
	smpsAlterNote	$FD
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FA
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F8
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F7
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F4
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$09
	dc.b		smpsNoAttack,	nD1
	smpsAlterNote	$07
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$05
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$02
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$01
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FF
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FD
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FC
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F9
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F7
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F6
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$09
	dc.b		smpsNoAttack,	nEb1
	smpsAlterNote	$07
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$05
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$02
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$01,	smpsNoAttack,	$7F,	smpsNoAttack,	$41
	smpsAlterNote	$05
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FA
	dc.b		smpsNoAttack,	nD1
	smpsAlterNote	$05
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0B
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	nCs1,	$7F,	smpsNoAttack,	$7F,	smpsNoAttack,	$20,	nC1
	dc.b		$23
	smpsAlterNote	$FC
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F5
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0A
	dc.b		smpsNoAttack,	nCs1
	smpsAlterNote	$03
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$21
	smpsAlterNote	$FE
	dc.b		$01
	smpsAlterNote	$FD
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FA
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F8
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F7
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F4
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$09
	dc.b		smpsNoAttack,	nD1
	smpsAlterNote	$07
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$05
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$02
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$01
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FF
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FD
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FC
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F9
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F7
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F6
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$09
	dc.b		smpsNoAttack,	nEb1
	smpsAlterNote	$07
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$05
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$02
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$01,	smpsNoAttack,	$7F,	smpsNoAttack,	$41
	smpsAlterNote	$05
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FA
	dc.b		smpsNoAttack,	nD1
	smpsAlterNote	$05
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$0B
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	nCs1,	$7F,	smpsNoAttack,	$7F,	smpsNoAttack,	$20,	nC1
	dc.b		$24,	nFs1,	$12
	smpsAlterNote	$02
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$03
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$06
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$08
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F7
	dc.b		smpsNoAttack,	nF1
	smpsAlterNote	$FA
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FD
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FE
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$01
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$04
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$06
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$09
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$F9
	dc.b		smpsNoAttack,	nE1
	smpsAlterNote	$FA
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$FD
	dc.b		smpsNoAttack,	$01
	smpsAlterNote	$00
	dc.b		smpsNoAttack,	$03
	smpsJump	MC_BOSS_Jump05

; PSG3 Data
MC_BOSS_PSG3:
	smpsPSGform	$E7
	dc.b		nRst,	$48
MC_BOSS_Jump06:
	dc.b		nA5
MC_BOSS_Loop58:
	dc.b		$09
	smpsSetVol	$02
	dc.b		$09,	$09,	$09
	smpsSetVol	$FE
	smpsLoop	$00,	$06,	MC_BOSS_Loop58
	dc.b		$09
	smpsSetVol	$02
	dc.b		$09
	smpsPSGvoice	$01
	dc.b		$12
	smpsPSGvoice	$02
MC_BOSS_Loop59:
	smpsSetVol	$FE
	dc.b		$09
	smpsSetVol	$02
	dc.b		$09,	$09,	$09
	smpsLoop	$00,	$07,	MC_BOSS_Loop59
	smpsSetVol	$FE
	dc.b		$09
	smpsSetVol	$02
	dc.b		$09
	smpsPSGvoice	$01
	dc.b		$12
	smpsPSGvoice	$02
MC_BOSS_Loop5A:
	smpsSetVol	$FE
	dc.b		$09
	smpsSetVol	$02
	dc.b		$09,	$09,	$09
	smpsLoop	$00,	$07,	MC_BOSS_Loop5A
	smpsSetVol	$FE
	dc.b		$09
	smpsSetVol	$02
	dc.b		$09
	smpsPSGvoice	$01
	dc.b		$12
	smpsPSGvoice	$02
MC_BOSS_Loop5B:
	smpsSetVol	$FE
	dc.b		$09
	smpsSetVol	$02
	dc.b		$09,	$09,	$09
	smpsLoop	$00,	$06,	MC_BOSS_Loop5B
	smpsSetVol	$FE
	dc.b		$09
	smpsSetVol	$02
	dc.b		$09,	$09,	$51
MC_BOSS_Loop5C:
	smpsSetVol	$FE
	dc.b		$09
	smpsSetVol	$02
	dc.b		$09,	$09,	$09
	smpsLoop	$00,	$06,	MC_BOSS_Loop5C
	smpsSetVol	$FE
	dc.b		$09
	smpsSetVol	$02
	dc.b		$09
	smpsPSGvoice	$01
	dc.b		$12
	smpsPSGvoice	$02
MC_BOSS_Loop5D:
	smpsSetVol	$FE
	dc.b		$09
	smpsSetVol	$02
	dc.b		$09,	$09,	$09
	smpsLoop	$00,	$07,	MC_BOSS_Loop5D
	smpsSetVol	$FE
	dc.b		$09
	smpsSetVol	$02
	dc.b		$09
	smpsPSGvoice	$01
	dc.b		$12
	smpsPSGvoice	$02
MC_BOSS_Loop5E:
	smpsSetVol	$FE
	dc.b		$09
	smpsSetVol	$02
	dc.b		$09,	$09,	$09
	smpsLoop	$00,	$07,	MC_BOSS_Loop5E
	smpsSetVol	$FE
	dc.b		$09
	smpsSetVol	$02
	dc.b		$09
	smpsPSGvoice	$01
	dc.b		$12
	smpsPSGvoice	$02
	smpsSetVol	$FE
	dc.b		$09
	smpsSetVol	$02
	dc.b		$09
	smpsPSGvoice	$01
	dc.b		$12
	smpsSetVol	$FE
MC_BOSS_Loop5F:
	dc.b		$12
	smpsLoop	$00,	$40,	MC_BOSS_Loop5F
	smpsPSGvoice	$02
	smpsJump	MC_BOSS_Jump06

MC_BOSS_Voices:
	dc.b		$2B,$3E,$51,$50,$50,$DF,$DF,$1B,$1F,$07,$0E,$07,$04,$07,$01,$01
	dc.b		$01,$54,$55,$F6,$77,$1F,$1C,$17,$0C;			Voice 00
	dc.b		$28,$33,$53,$70,$30,$DF,$DC,$1F,$1F,$14,$05,$01,$81,$00,$01,$00
	dc.b		$1D,$11,$21,$10,$F8,$0E,$1B,$12,$0C;			Voice 01
	dc.b		$38,$53,$51,$51,$51,$DF,$DF,$1F,$1F,$07,$0E,$07,$84,$04,$03,$03
	dc.b		$08,$F7,$31,$71,$67,$1B,$11,$10,$0C;			Voice 02
	dc.b		$3A,$32,$01,$02,$01,$10,$13,$10,$1B,$00,$00,$00,$00,$09,$08,$08
	dc.b		$00,$F7,$F7,$F7,$27,$16,$14,$18,$0A;			Voice 03
	dc.b		$3A,$01,$07,$31,$71,$8E,$8E,$8D,$53,$0E,$0E,$0E,$06,$00,$00,$00
	dc.b		$00,$1F,$FF,$1F,$2F,$18,$28,$27,$00;			Voice 04
	even
